package org.msh.reports;

import org.msh.reports.filters.Filter;
import org.msh.reports.filters.FilterOperation;

public class FilterValue {

	private Filter filter;
	private FilterOperation comparator;
	private String value;
	
	private FilterValue(Filter filter, FilterOperation comparator, String value) {
		super();
		this.filter = filter;
		this.comparator = comparator;
		this.value = value;
	}

    static public FilterValue parseString(Filter filter, String value) {
	    FilterOperation oper = FilterOperation.EQUALS;
	    String sval = value;

        if (sval != null) {
            sval = sval.trim();

            // check if there is any operator at the beginning of the filter definition
            String[] s = sval.split(" ");
            FilterOperation tmp = getFilterOperation(s[0]);

            if (tmp != null) {
                oper = tmp;
                sval = "";
                // reconstruct the value
                if (s.length > 1) {
                    String delim = "";
                    for (String tk: s) {
                        sval += delim + tk;
                        delim = " ";
                    }
                }
            }
        }

        return new FilterValue(filter, oper, sval);
    }

    /**
     * Return the filter operation by its oper
     * @param oper
     * @return
     */
    private static FilterOperation getFilterOperation(String oper) {
        for (FilterOperation fo: FilterOperation.values()) {
            if (fo.getOper().equals(oper)) {
                return fo;
            }
        }
        return null;
    }

	/**
	 * @return the filter
	 */
	public Filter getFilter() {
		return filter;
	}

	/**
	 * @param filter the filter to set
	 */
	public void setFilter(Filter filter) {
		this.filter = filter;
	}

	/**
	 * @return the comparator
	 */
	public FilterOperation getComparator() {
		return comparator;
	}

	/**
	 * @param comparator the comparator to set
	 */
	public void setComparator(FilterOperation comparator) {
		this.comparator = comparator;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
}
